#ifndef _fma_lag_h
#define _fma_lag_h
#ifndef MCP
#include <string.h>
#endif
/*
 * Link aggregation structures and definitions
 */

/* standards defined length of Link Aggregation ID */
#define LF_LAG_ID_LEN 26

#define FMA_LAG_HASH_TABLE_SIZE 1024

#define fma_lag_match(L1, L2) (memcmp((L1), (L2), LF_LAG_ID_LEN)==0)
#define fma_lag_copy(D, S) memcpy((D), (S), LF_LAG_ID_LEN)

/* Used to assign mag_ids to lag_id holders */
struct fma_lag_id_def {
  unsigned char lag_id[LF_LAG_ID_LEN];
  int lag_ref_cnt;

  struct fma_lag_id_def *lag_hash_next;	/* same hash value */
  struct lf_nic *lag_nic_list;		/* List of NICs with same value */
};

/*
 * prototypes
 */
void fma_lag_assign_mag_ids(struct lf_fabric *);
char *fma_lag_id_string(unsigned char *lag_id);

/*
 * inlines
 */
static inline int
fma_lag_hash(
  unsigned char *lag_id)
{
  int i;
  int hash;

  hash = *lag_id++;
  for (i=1; i<LF_LAG_ID_LEN; ++i) {
    hash ^= *lag_id++;
  }
  return hash;
}

#endif /* _fma_lag_h */
